
// This scilab code is used to calculate distance measure between different vectors
//such as euclidean distance, checkerboard distance and mahalanobis distance

//The scilab environment for this is : Scilab 6.0.1

//OS used : Windows 10 64 bit
// 
//Reference book name : Digital Image Processing
//book author: Rafael C. Gonzalez and Richard E. Woods

//clc //to clear command window.
clear all //to kill previously defined variables.
//xdel(winsid())//to close all currently open figure(s).

//A  = rand(1, 100);                          // Create a vector of random values
//B = rand(1, 100);                           //  Creates another vector of random values

A = [5.76 43 34;6.7 32 5;3 3 5;34 12 6];    // Create a vector A
B = [1.55 5 32;4.5 9 8;2 4 3;3.2 6 7];                            // Create a vector B

// Euclidean Distance
D  = sqrt(sum((A - B) .^ 2))                // Calculates euclidean distance between A and B
Da  = sqrt(sum((A - A) .^ 2))               // Calculates euclidean distance between A itself
Db  = sqrt(sum((B - B) .^ 2))               // Calculates euclidean distance between B itself


// Checkerboard Distance
Dc1 = sum(sum((A-B).^2,2))                       // Calculates Checkerboard distance between A and B
Dc2 = sum(sum((A-A).^2,2))                       // Calculates Checkerboard distance between A and B
Dc3 = sum(sum((B-B).^2,2))                       // Calculates Checkerboard distance between A itself


// Mahalanobis Distance
A = [5.76 43 34;6.7 32 5;3 3 5;34 12 6];    // Create a vector A
B = [1.55 5 32];                            // Create a vector B
cv = cov(A);                                // Calculate covariance matrix of A
mu = mean(A,1);                             // Calucated mean value of A
Dm = (B-mu)*inv(cv)*(B-mu)';                 // Calculates Mahalanobis distance between A and B
//out=[D Da Db Dc1 Dc2 Dc3 Dm]
disp([D Da Db Dc1 Dc2 Dc3 Dm]);             // Displays output on Scilab console

////////////////////////////// OUTPUT ////////////////////////////////////////////////

//54.774119   0.   0.   3000.2041   0.   0.   11.17056


